#include <string>
#include <vector>
#include <stdint.h> 
#include <ostream>
#include <iostream>


#define byte uint8_t

#include "rbensh.h"

#ifdef multicore
	#include <thread>
	#include <future>
#endif

std::vector <std::string> nToRomanGetN(size_t startval, size_t endval)
{
	std::vector <std::string> out = {};
	return out;
}

std::vector <std::string> nToRoman(size_t startval, size_t endval, byte viewType)
{
	std::vector <std::string> out = {};
	byte index;
	byte base10;
	std::string svar;
	char I = 'I';
	char V = 'V';
	char X = 'X';
	char temp[5];
    
	for(size_t r = startval; r <= endval; r++)
	{
		sprintf(temp, "%ld", r);
		index = 1;
		svar = "";
		while(temp[index] != '\0'){index++;}
		byte base10Counter = 0;
		for(index; index > 0; index--)
		{
			base10 = temp[base10Counter++] - 48;
			switch(index)
			{
				case 1:
				I = 'I';
				V = 'V';
				X = 'X';
				break;
				case 2:
				I = 'X';
				V = 'L';
				X = 'C';
				break;
				case 3:
				I = 'C';
				V = 'D';
				X = 'M';
				break;
				case 4:
				I = 'M';
				break;
			}
			switch(base10)
			{
				case 1:
				svar += I;
				break;
				case 2:
				svar += I;
				svar += I;
				break;
				case 3:
				svar += I;
				svar += I;
				svar += I;
				break;
				case 4:
				svar += I;
				svar += V;
				break;
				case 5:
				svar += V;
				break;
				case 6:
				svar += V;
				svar += I;
				break;
				case 7:
				svar += V;
				svar += I;
				svar += I;
				break;
				case 8:
				svar += V;
				svar += I; 
				svar += I; 
				svar += I;
				break;
				case 9:
				svar += I;
				svar += X;
				break;	
			}
	     }
	   
	   out.push_back(svar);
  }
  
 return out;
}

std::vector <std::string> scheduler(struct joblist *list, byte threads)
{
	std::vector <std::string> out = {};
	std::vector <std::string> part2 = {};

	
#ifdef multicore	
	unsigned int jobb_per_thread;
	if(threads > 1)
	{
	    jobb_per_thread = (list->endval - list->startval) / threads;
		if(jobb_per_thread <= 0){threads = 1;}
    }
#endif
	switch(threads)
	{		
		case 1:
		out = nToRoman(list->startval, list->endval, list->viewType);
		break;
		
		case 2:
		byte ascend_core = 0;
		unsigned int startvalDist = list->startval;
		struct coreArgs core1Args;
        struct coreArgs core2Args;
         
		core1Args.startval = startvalDist + (jobb_per_thread * ascend_core);
		core1Args.endval = startvalDist + (jobb_per_thread * ascend_core++) + jobb_per_thread;

		core2Args.startval = startvalDist + (jobb_per_thread * ascend_core) + 1;
		core2Args.endval = startvalDist + (jobb_per_thread * ascend_core++) + jobb_per_thread;
		
		core1Args.viewType = list->viewType;
		core2Args.viewType = list->viewType;

		auto pusher = [&out, core1Args]()
		{
			out = nToRoman((core1Args.startval), (core1Args.endval), (core1Args.viewType));
		};
		  
		auto pusher2 = [&part2,core2Args]()
		{
			part2 = nToRoman((core2Args.startval), (core2Args.endval), (core2Args.viewType));
		};
		 std::thread core1(pusher);
		 std::thread core2(pusher2);
		 core1.join();
		 core2.join();
		 
		 out.insert(out.end(), part2.begin(), part2.end());
		
		break;
	
	}
	
	return out;
}
