#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h> //memcpy

#ifdef multicore	
	#include <pthread.h>
#endif

#define byte uint8_t

#include "rbensh.h"


void* nToRomanGetN(void* sptArgs)
{
	return NULL;
}

void* nToRoman(void* sptArgs)
{
	struct coreArgs* cArgs = (struct coreArgs*) sptArgs;
	
	byte index;
	byte base10;
    char svar[16];
    char* ptMem = cArgs->memStart;

    byte svarPos = 0;
	char I = 'I';
	char V = 'V';
	char X = 'X';
	char temp[5];
    unsigned int storeIndexCounter = 0;

	for(unsigned int r = cArgs->startval; r <= cArgs->endval; r++)
	{
		sprintf(temp, "%d", r);
		index = 1;
		svarPos = 0;
		while(temp[index] != '\0'){index++;}
		byte base10Counter = 0;
		for(index; index > 0; index--)
		{
			base10 = temp[base10Counter++] - 48;
			switch(index)
			{
				case 1:
				I = 'I';
				V = 'V';
				X = 'X';
				break;
				case 2:
				I = 'X';
				V = 'L';
				X = 'C';
				break;
				case 3:
				I = 'C';
				V = 'D';
				X = 'M';
				break;
				case 4:
				I = 'M';
				break;
			}
			switch(base10)
			{
				case 1:
				svar[svarPos++] = I;
				break;
				case 2:
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				break;
				case 3:
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				break;
				case 4:
				svar[svarPos++] = I;
				svar[svarPos++] = V;

				break;
				case 5:
				svar[svarPos++] = V;
				break;
				case 6:
				svar[svarPos++] = V;
				svar[svarPos++] = I;
				break;
				case 7:
				svar[svarPos++] = V;
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				break;
				case 8:
				svar[svarPos++] = V;
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				svar[svarPos++] = I;
				break;
				case 9:
				svar[svarPos++] = I;
				svar[svarPos++] = X;
				break;	
			}
	     }
	     
	   svar[svarPos] = '\0';
	   byte n = 0;
       unsigned int pos = 0;
	   while(svar[n] != '\0')
	   {
		   pos = (storeIndexCounter * 16) + n;  
		   ptMem[pos] = svar[n++];
	   }
	   ptMem[++pos] = '\0';
	   storeIndexCounter++;
	}
	
	return NULL;
}

char* scheduler(struct joblist *argsList, byte threads)
{
	static char* ptrMem = NULL;

    unsigned int memPageSize = (argsList->endval - argsList->startval) + 1;

	// Dynamically allocate memory using malloc()
    ptrMem = (char*) malloc((16 * sizeof(char)) * memPageSize);
    char* ptrMemWriteStart = ptrMem;
    ptrMemWriteStart += 8;

#ifndef multicore	
	if(threads > 1)
	{
		perror("call error no multicore build:");  
	    free(ptrMem);
		return NULL;  
	}
#endif

#ifdef multicore	
	unsigned int jobb_per_thread;
	if(threads > 1)
	{
	    jobb_per_thread = (argsList->endval - argsList->startval) / threads;
		if(jobb_per_thread <= 0){threads = 1;}
    }

	switch(threads)
	{	
		case 1:
		struct coreArgs core0Args;	
		core0Args.memStart = ptrMemWriteStart;
		core0Args.startval = argsList->startval;
		core0Args.endval = argsList->endval;
		core0Args.viewType = argsList->viewType;
		nToRoman(&core0Args);
		break;
			
		case 2:
		pthread_t core1;
		pthread_t core2;
		char* memSCore1 = ptrMemWriteStart;
		char* memSCore2 = ptrMemWriteStart;
		memSCore2 += (jobb_per_thread * 16) + 16;
		byte ascend_core = 0;
		unsigned int startvalDist = argsList->startval;
		struct coreArgs core1Args;
        struct coreArgs core2Args;
        
        core1Args.memStart = memSCore1;
        core2Args.memStart = memSCore2;
 
		core1Args.startval = startvalDist + (jobb_per_thread * ascend_core);
		core1Args.endval = startvalDist + (jobb_per_thread * ascend_core++) + jobb_per_thread;

		core2Args.startval = startvalDist + (jobb_per_thread * ascend_core) + 1;
		core2Args.endval = startvalDist + (jobb_per_thread * ascend_core++) + jobb_per_thread;
		
		core1Args.viewType = argsList->viewType;
		core2Args.viewType = argsList->viewType;

		pthread_create(&core1, NULL, nToRoman, &core1Args);
		pthread_create(&core2, NULL, nToRoman, &core2Args);
		
	    pthread_join(core1, NULL);
	    pthread_join(core2, NULL);

		break;
	    case 3:
	    return NULL;
		break;
		case 4:
	    return NULL;
		break;
		case 5:
	    return NULL;
		break;
		case 6:
	    return NULL;
		break;
		case 7:
		return NULL;
		break;
		case 8:
		return NULL;
		break;
		case 9:
		return NULL;
		break;	
		case 10:
		return NULL;
		break;
		case 11:
		return NULL;
		break;
		case 12:
		return NULL;
		break;	
	}
#endif

#ifndef multicore
	struct coreArgs core0Args;	
	core0Args.memStart = ptrMemWriteStart;
    core0Args.startval = argsList->startval;
    core0Args.endval = argsList->endval;
    core0Args.viewType = argsList->viewType;
	nToRoman(&core0Args);

#endif

	return ptrMem;
}
